package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.news.config.LotteryFlauntForumProperties;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.vo.ExtJumpInfo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.localnews.url.ProtocolFactory;
import com.bxm.newidea.component.annotations.FilterBean;
import lombok.AllArgsConstructor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import java.util.List;
import java.util.Objects;

import static com.bxm.localnews.news.content.replace.html.LotteryFlauntJumpUrlReplace.LOTTERY_FLAUNT_JUMP_URL_SELECT;

/**
 * 话题信息填充
 *
 * @author liujia
 * @date 1/14/21 10:37 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
@AllArgsConstructor
public class TopicFillFilter extends AbstractPostDetailFilter {

    private ForumTopicService forumTopicService;

    private LotteryFlauntForumProperties lotteryFlauntForumProperties;

    private DomainIntegrationService domainIntegrationService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();

        List<TopicVo> topicVoList = forumTopicService.loadTopicByIds(forumPostVo.getTopicIds(),
                context.getLocation(),
                context.getUserId());

        //填充话题分享url
        for (TopicVo topicVo : topicVoList) {
            topicVo.setShareUrl(ProtocolFactory.topic().outer()
                    .userId(context.getOriginalParam().getUserId())
                    .topicId(topicVo.getId())
                    .areaCode(context.getAreaCode()).build());

            if (Objects.equals(topicVo.getId(), lotteryFlauntForumProperties.getLotteryFlauntTopicId())) {
                setJumpInfo(forumPostVo);
            }
        }

        forumPostVo.setTopicList(topicVoList);
    }

    /**
     * 如果是夺宝话题的帖子，设置特殊的跳转地址
     *
     * @param forumPostVo 帖子信息
     */
    private void setJumpInfo(ForumPostVo forumPostVo) {
        Document document = Jsoup.parse(forumPostVo.getContent());
        if (Objects.nonNull(document) && !document.select(LOTTERY_FLAUNT_JUMP_URL_SELECT).isEmpty()) {
            // 设置列表的拓展信息
            ExtJumpInfo jumpInfo = new ExtJumpInfo();
            // 文案
            jumpInfo.setText(lotteryFlauntForumProperties.getForumText());
            // 拼接base url
            jumpInfo.setJumpUrl(domainIntegrationService.getInnerH5BaseUrl() + lotteryFlauntForumProperties.getForumJumpUrl());
            forumPostVo.setExtJumpInfo(jumpInfo);
        }
    }
}
