package com.bxm.localnews.news.detail.filter;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.annotations.FilterBean;

import javax.annotation.Resource;

/**
 * 填充马甲号信息
 *
 * @author liujia
 * @date 1/14/21 10:42 AM
 **/
@FilterBean(group = LogicGroupConstant.POST_DETAIL_FILTER)
public class VestTypeFillFilter extends AbstractPostDetailFilter {

    @Resource
    private UserIntegrationService userIntegrationService;

    @Override
    void internalDoFilter(ForumPostDetailContext context) {
        ForumPostVo forumPostVo = context.getPostInfo();
        forumPostVo.setVestType(userIntegrationService.getVirtualUserType(forumPostVo.getUserId()));
    }
}
