package com.bxm.localnews.news.detail.rule;

import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.rule.IRule;

import java.util.Objects;

/**
 * 限制下架、删除的帖子对外展示
 * 可用于数据召回操作
 *
 * @author liujia
 * @date 1/14/21 9:40 AM
 **/
@RuleBean(group = LogicGroupConstant.POST_DETAIL_RULE)
public class BlackPostRule implements IRule<ForumPostDetailContext> {
    @Override
    public boolean apply(ForumPostDetailContext context) {
        boolean isClient = context.isOutSide();

        boolean rejectedStatus = Objects.equals(PostStatusEnum.REJECTED.getCode(), context.getPostStatus());
        boolean deleteStatus = Objects.equals(PostStatusEnum.USER_DELETE.getCode(), context.getPostStatus()) ||
                Objects.equals(PostStatusEnum.OPERATOR_DELETE.getCode(), context.getPostStatus());

        // 客户端不显示已经删除的帖子
        if (isClient && deleteStatus) {
            context.setEmptyPost();
            return false;
        }

        // 站外不显示拒绝的、删除的帖子
        boolean hidePost = !isClient && (rejectedStatus || deleteStatus);
        if (hidePost) {
            context.setEmptyPost();
            return false;
        }

        return true;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
