package com.bxm.localnews.news.detail.rule;

import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.LogicGroupConstant;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.detail.context.ForumPostDetailContext;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.newidea.component.annotations.RuleBean;
import com.bxm.newidea.component.redis.HyperLogLogAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.rule.IRule;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * 站外阅读次数限制，防止传播次数过多
 *
 * @author liujia
 * @date 1/14/21 9:40 AM
 **/
@RuleBean(group = LogicGroupConstant.POST_DETAIL_RULE)
public class ViewLimitRule implements IRule<ForumPostDetailContext> {

    @Resource
    private ForumProperties forumProperties;

    @Resource
    private HyperLogLogAdapter hyperLogLogAdapter;

    @Override
    public boolean apply(ForumPostDetailContext context) {
        if (!context.isOutSide()) {
            return true;
        }

        // 审核中的帖子才需要做限制
        if (Objects.equals(PostStatusEnum.APPROVING.getCode(), context.getPostInfo().getStatus())) {
            KeyGenerator keyGenerator = RedisConfig.FORUM_RECORD_FROM_H5.copy().appendKey(context.getPostId());

            Long recordNum = hyperLogLogAdapter.size(keyGenerator);

            // 如果站外浏览次数达到了限额，则返回空对象，前端显示为帖子被限制访问
            if (null != recordNum && recordNum >= forumProperties.getH5LimitNum()) {
                context.setEmptyPost();

                return false;
            }
        }
        return true;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
