package com.bxm.localnews.news.forum;

import com.bxm.localnews.news.model.param.AdminForumParam;
import com.bxm.localnews.news.model.param.AdminForumUpdateParam;
import com.bxm.localnews.news.model.vo.AdminForum;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 版块管理服务
 */
public interface AdminForumService {

    /**
     * 查询版块
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<AdminForum> getList(AdminForumParam param);

    /**
     * 获取版块详情
     *
     * @param id
     * @return
     */
    AdminForum selectByPrimaryKey(Long id);

    /**
     * 版块上下架
     *
     * @param id
     * @param status
     * @return 更新信息
     */
    int updateStatus(Long id, Byte status);

    /**
     * 新增或编辑版块
     *
     * @param adminForum
     * @return
     */
    int saveOrUpdate(AdminForum adminForum);

    /**
     * 修改版块权重
     *
     * @param id
     * @param order
     * @return
     */
    int updateOrder(Long id, Integer order);

    /**
     * 获取简单版块列表
     *
     * @param key
     * @return
     */
    List<AdminForum> getSimpleList(String key);

    /**
     * 更新帖子中的板块
     *
     * @param adminForumUpdateParam
     */
    void updatePostForum(AdminForumUpdateParam adminForumUpdateParam);
}
