package com.bxm.localnews.news.forum.impl;

import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.AdminAreaRelationMapper;
import com.bxm.localnews.news.domain.AdminForumMapper;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.forum.AdminForumService;
import com.bxm.localnews.news.model.dto.AdminAreaRelationDTO;
import com.bxm.localnews.news.model.param.AdminForumParam;
import com.bxm.localnews.news.model.param.AdminForumUpdateParam;
import com.bxm.localnews.news.model.vo.AdminForum;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.PageWarper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class AdminForumServiceImpl implements AdminForumService {

    @Resource
    private AdminForumMapper adminForumMapper;

    @Resource
    private AdminAreaRelationMapper adminAreaRelationMapper;

    @Resource
    private LocationIntegrationService locationIntegrationService;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Resource
    private AdminForumPostMapper adminForumPostMapper;

    @Override
    public PageWarper<AdminForum> getList(AdminForumParam param) {
        PageWarper<AdminForum> forumList = new PageWarper<>(adminForumMapper.getList(param));

        if (CollectionUtils.isNotEmpty(forumList.getList())) {
            for (AdminForum adminForum : forumList.getList()) {
                completeForum(adminForum);
            }
        }

        return forumList;
    }

    @Override
    public AdminForum selectByPrimaryKey(Long id) {
        AdminForum adminForum = adminForumMapper.selectByPrimaryKey(id);
        completeForum(adminForum);
        return adminForum;
    }

    @Override
    public int updateStatus(Long id, Byte status) {
        AdminForum adminForum = this.adminForumMapper.selectByPrimaryKey(id);
        if (adminForum == null) {
            return 0;
        }
        adminForum.setEnable(status);
        this.adminForumMapper.updateByPrimaryKeySelective(adminForum);
        removeCache();

        return 1;
    }

    @Override
    public int saveOrUpdate(AdminForum adminForum) {
        int update;
        Long id = adminForum.getId();

        if (null == id) {
            id = sequenceCreater.nextLongId();
            adminForum.setId(id);
            adminForum.setCreateTime(new Date());
            update = this.adminForumMapper.insert(adminForum);
        } else {
            update = this.adminForumMapper.updateByPrimaryKeySelective(adminForum);
            //adminForumPostMapper.updateForumContentByForumId(adminForum.getId(),adminForum.getContent());
        }

        adminAreaRelationMapper.batchDelete(adminForum.getId(), 1);
        if (CollectionUtils.isNotEmpty(adminForum.getAreaCodes())) {
            List<AdminAreaRelationDTO> list = new ArrayList<>();
            for (String areaCode : adminForum.getAreaCodes()) {
                AdminAreaRelationDTO adminAreaRelationDTO = new AdminAreaRelationDTO();
                adminAreaRelationDTO.setId(sequenceCreater.nextLongId());
                adminAreaRelationDTO.setRelationId(adminForum.getId());
                adminAreaRelationDTO.setAreaCode(areaCode);
                adminAreaRelationDTO.setType((byte) 1);
                list.add(adminAreaRelationDTO);
            }
            adminAreaRelationMapper.batchInsert(list);
        }

        removeCache();

        return update;
    }

    @Override
    public int updateOrder(Long id, Integer order) {
        AdminForum adminForum = this.adminForumMapper.selectByPrimaryKey(id);
        if (adminForum == null) {
            return 0;
        }
        adminForum.setOrder(order);
        this.adminForumMapper.updateByPrimaryKeySelective(adminForum);
        removeCache();

        return 1;
    }

    @Override
    public List<AdminForum> getSimpleList(String key) {
        AdminForumParam param = new AdminForumParam();
        param.setTitle(key);
        param.setPageSize(0);
        return adminForumMapper.getList(param);
    }

    @Override
    public void updatePostForum(AdminForumUpdateParam adminForumUpdateParam) {
        adminForumMapper.updatePostForum(adminForumUpdateParam);
    }

    private void completeForum(AdminForum adminForum) {
        if (adminForum != null) {
            adminForum.setAreaCodes(adminAreaRelationMapper.getAreaCodes(adminForum.getId(), 1));
            adminForum.setAreas(locationIntegrationService.batchFetch(adminForum.getAreaCodes()));
        }
    }

    /**
     * 获取版块列表的key
     *
     * @return
     */
    private KeyGenerator getKey() {
        return RedisConfig.FORUM.copy();
    }

    /**
     * 移除缓存
     */
    private void removeCache() {
        redisHashMapAdapter.remove(this.getKey());
    }
}
