package com.bxm.localnews.news.hotpost;

import com.bxm.localnews.news.model.dto.PostBarrageDTO;
import com.bxm.localnews.news.model.param.activity.PostDetailBarrageParam;
import com.bxm.localnews.news.model.vo.hotpost.HotPostBulletVO;

import java.util.List;

/**
 * 活动帖子和热文帖子弹幕相关接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/28 9:45 上午
 */
public interface HotPostBulletService {
    /**
     * 获取活动帖子弹幕相关信息
     *
     * @param param 查询入参
     * @return 弹幕相关信息
     */
    PostBarrageDTO getPostBarrage(PostDetailBarrageParam param);

    /**
     * 获取热文帖子弹幕
     *
     * @param areaCode 地区编码
     * @return 热文帖子弹幕列表
     */
    List<HotPostBulletVO> shareHotPostBullet(String areaCode);


}