package com.bxm.localnews.news.hotpost;

import com.bxm.localnews.news.model.dto.hotpost.HotPostShareCashDTO;
import com.bxm.localnews.news.model.param.activity.ActivityPostReportParam;
import com.bxm.localnews.news.model.param.hotpost.HotPostListPageParam;
import com.bxm.localnews.news.model.param.hotpost.HotPostReportParam;
import com.bxm.localnews.news.model.vo.hotpost.HotPostCounterInfoVO;
import com.bxm.localnews.news.model.vo.hotpost.HotPostItemVO;
import com.bxm.localnews.news.model.vo.hotpost.ReadReportVO;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 热文帖子分享service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/18 9:28 上午
 */
public interface HotPostShareService {

    /**
     * 获取用户热文相关的统计信息
     *
     * @param userId 用户id
     * @return 统计信息
     */
    HotPostCounterInfoVO counterInfo(Long userId);

    /**
     * 获取热文帖子列表
     *
     * @param param 查询入参
     * @return 返回热文帖子列表
     */
    List<HotPostItemVO> hotPostList(HotPostListPageParam param);

    /**
     * 获取用户的热文分享奖金金额
     *
     * @param userId 用户id
     * @return 热文分享奖金信息
     */
    HotPostShareCashDTO getUserCashInfo(Long userId);

    /**
     * 上报阅读热文贴子
     *
     * @param param   上报入参
     * @param request 请求对象
     * @return 结果信息
     */
    ReadReportVO reportRead(HotPostReportParam param, HttpServletRequest request);

    /**
     * 获取当前热文分享奖励信息（用于收益排行榜）
     *
     * @return 热文奖励信息
     */
    List<HotPostShareCashDTO> getCashInfo();

    /**
     * 上报点击参与活动帖子按钮
     *
     * @param param 上报参数
     */
    void reportJoinActivity(ActivityPostReportParam param);
}