package com.bxm.localnews.news.hotpost;

import com.bxm.localnews.news.model.dto.hotpost.ShareCashPostItemDTO;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.localnews.news.model.param.hotpost.ShareCashPostAwardParam;
import com.bxm.localnews.news.model.param.hotpost.ShareCashPostOrderParam;
import com.bxm.localnews.news.model.param.hotpost.ShareCashPostPageParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

/**
 * 有奖热文管理相关接口
 *
 * @author liujia
 * @date 1/19/21 2:08 PM
 **/
public interface ShareCashPostService {

    /**
     * 变更有奖热文的排序
     *
     * @param param 变更参数
     * @return 变更结果
     */
    Message changeOrder(ShareCashPostOrderParam param);

    /**
     * 变更有奖热文的有效状态
     *
     * @param postId 有奖热文帖子ID
     * @param status 有奖热文状态，1：有效，0：无效
     * @return
     */
    Message changeStatus(Long postId, Integer status);

    /**
     * 变更有奖热文奖励有效期时间
     *
     * @param param 变更参数
     * @return 操作结果
     */
    Message changeAwardTime(ShareCashPostAwardParam param);

    /**
     * 根据帖子获取有奖热文详情
     *
     * @param postId 帖子ID
     * @return 有奖热文相关字段详情
     */
    ForumPostShareCashInfoEntity getDetail(Long postId);

    /**
     * 分页获取有奖热文信息
     *
     * @param param 分页参数
     * @return 分页结果
     */
    PageWarper<ShareCashPostItemDTO> queryByPage(ShareCashPostPageParam param);

    /**
     * 保存有奖热文信息
     *
     * @param entity 有奖热文信息
     * @return 保存结果
     */
    Message save(ForumPostShareCashInfoEntity entity);

    /**
     * 扫描即将过期的热文，将其设置为过期状态
     */
    void setExpired();

    /**
     * 扫描未开启的热文，超过当前时间则进行开启
     */
    void setStart();
}
