package com.bxm.localnews.news.hotpost.filter.chain;

import com.bxm.localnews.news.hotpost.filter.IHotPostCashFilter;
import com.bxm.localnews.news.hotpost.filter.context.HotPostShareContext;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/18 2:46 下午
 */
@Component
public class HotPostCashFilterChain {
    private final List<IHotPostCashFilter> filters;

    public HotPostCashFilterChain(List<IHotPostCashFilter> filters) {
        this.filters = filters;
    }

    public Message handle(HotPostShareContext shareContext) {
        for (IHotPostCashFilter filter : filters) {
            Message isSuccessMsg = filter.handle(shareContext);
            if (Boolean.FALSE.equals(isSuccessMsg.isSuccess())) {
                return isSuccessMsg;
            }
        }
        return Message.build(true);
    }
}