package com.bxm.localnews.news.hotpost.filter.context;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 热文帖子分享上下文对象
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/18 3:15 下午
 */
@Data
public class HotPostShareContext {

    @ApiModelProperty("帖子id")
    private Long postId;

    @ApiModelProperty("阅读用户openid")
    private String openid;

    @ApiModelProperty("分享帖子的受益人用户id")
    private Long shareUserId;

    @ApiModelProperty("上报的日期")
    private Date reportDate;

    @ApiModelProperty("用户userAgent")
    private String userAgent;

    @ApiModelProperty("用户ip")
    private String ip;

    @ApiModelProperty("分享人的地区编码")
    private String areaCode;
}