package com.bxm.localnews.news.hotpost.filter.support;

import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashInfoMapper;
import com.bxm.localnews.news.hotpost.filter.IHotPostCashFilter;
import com.bxm.localnews.news.hotpost.filter.context.HotPostShareContext;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashInfoEntity;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 帖子状态filter
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/18 2:43 下午
 */
@Component
@AllArgsConstructor
@Order(2)
public class HotPostStatusFilter implements IHotPostCashFilter {

    private final ForumPostMapper forumPostMapper;

    private final ForumPostShareCashInfoMapper forumPostShareCashInfoMapper;

    @Override
    public Message handle(HotPostShareContext shareContext) {
        Long postId = shareContext.getPostId();

        boolean existHotPost = forumPostMapper.existHotPost(postId);
        //热文是否存在并且是否是热文
        if (Boolean.FALSE.equals(existHotPost)) {
            return Message.build(false, "热文不存在或已失效");
        }

        ForumPostShareCashInfoEntity sharePostInfo = forumPostShareCashInfoMapper.getByPostId(postId);

        if (Objects.isNull(sharePostInfo)) {
            return Message.build(false, "热文信息为空");
        }

        //判断时间是否在奖励时间范围内
        if (sharePostInfo.getStatus() == 0) {
            return Message.build(false, "热文已失效");
        }

        return Message.build(true);
    }
}