package com.bxm.localnews.news.hotpost.filter.support;

import com.bxm.localnews.common.vo.IP;
import com.bxm.localnews.dto.LocationProvinceAndCityDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.hotpost.filter.IHotPostCashFilter;
import com.bxm.localnews.news.hotpost.filter.context.HotPostShareContext;
import com.bxm.localnews.news.util.IPConvertUtil;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.Objects;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/21 6:11 下午
 */
@Slf4j
@Component
@AllArgsConstructor
@Order(1)
public class IpFilter implements IHotPostCashFilter {

    private UserIntegrationService userIntegrationService;

    private LocationIntegrationService locationIntegrationService;

    @Override
    public Message handle(HotPostShareContext shareContext) {
        //判断ip是否在同一个城市，定位不到城市就去定位省份
        UserBean shareUser = userIntegrationService.selectUserFromCache(shareContext.getShareUserId());
        if (null == shareUser) {
            return Message.build(false, "分享用户不存在");
        }

        String loginIp = shareContext.getIp();
        IP ipInfo = IPConvertUtil.find(loginIp);

        if (null == ipInfo) {
            log.info("IP:[{}]不存在于IP库", shareContext.getIp());
            return Message.build(false, "Ip不存在ip库");
        }

        LocationProvinceAndCityDTO provinceAndCityInfo = locationIntegrationService.getProvinceAndCityInfo(shareContext.getAreaCode());

        if (Objects.isNull(provinceAndCityInfo)) {
            return Message.build(false, "分享者的areaCode信息无效，无法获取省市信息");
        }

        String cityName = provinceAndCityInfo.getCity();

        String provinceName = provinceAndCityInfo.getProvince();

        //替换掉省市字符
        if (isNotBlank(cityName)) {
            cityName = cityName.replace("市", "");
        }

        if (isNotBlank(provinceName)) {
            provinceName = provinceName.replace("省", "");
        }

        //先匹配市，然后匹配省，如果都匹配不到则过滤掉这个参与用户
        if (isNotBlank(cityName) && StringUtils.equals(cityName, ipInfo.getCity())) {
            return Message.build(true);
        }

        if (isNotBlank(provinceName) && StringUtils.equals(provinceName, ipInfo.getProvince())) {
            return Message.build(true);
        }

        return Message.build(false, "不在指定区域，ip登录省份："
                + ipInfo.getProvince() + ",ip登录城市：" + ipInfo.getCity() +
                "分享用户省份：" + provinceAndCityInfo.getProvince() + ",分享用户城市：" + provinceAndCityInfo.getCity());
    }
}