package com.bxm.localnews.news.hotpost.filter.support;

import com.bxm.localnews.news.config.SharePostCashProperties;
import com.bxm.localnews.news.domain.activity.ForumPostShareCashCounterMapper;
import com.bxm.localnews.news.hotpost.filter.IHotPostCashFilter;
import com.bxm.localnews.news.hotpost.filter.context.HotPostShareContext;
import com.bxm.localnews.news.model.entity.activity.ForumPostShareCashCounterEntity;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/19 2:20 下午
 */
@Component
@AllArgsConstructor
@Order(4)
public class UserShareStatusFilter implements IHotPostCashFilter {

    private final ForumPostShareCashCounterMapper forumPostShareCashCounterMapper;

    private final SharePostCashProperties sharePostCashProperties;

    @Override
    public Message handle(HotPostShareContext shareContext) {

        //判断分享用户（受益人）的奖励金额是否达到上限，如果达到上限则不进行记录
        Long shareUserId = shareContext.getShareUserId();

        ForumPostShareCashCounterEntity counterEntity = forumPostShareCashCounterMapper.selectByDateAndUserId(shareUserId, getCurrentDateStr());

        if (Objects.isNull(counterEntity)) {
            return Message.build(true);
        }

        if (counterEntity.getAwardAmount().compareTo(sharePostCashProperties.getLimitAward()) >= 0) {
            return Message.build(false, "用户已经达到今日热文奖励上限");
        }

        return Message.build(true);
    }

    /**
     * 获取当前日期字符串，格式：2021-01-02
     *
     * @return 当前日期字符串
     */
    private String getCurrentDateStr() {
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtils.DATE_FORMAT);

        return sdf.format(new Date());
    }
}