package com.bxm.localnews.news.hotpost.msg;

import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

/**
 * 热文分享的消息通道
 *
 * @author wzy
 * @version 1.0
 * @date 2021/2/1 2:22 下午
 */
public interface HotPostProcessor {

    /**
     * 消费生产者的配置
     */
    String HOT_POST_OUTPUT = "hotPostOutPut";

    @Output("hotPostOutPut")
    MessageChannel hotPostOutPut();

    /**
     * 消息消费者配置
     */
    String HOT_POST_INPUT = "hotPostInput";

    @Input("hotPostInput")
    SubscribableChannel hotPostInput();
}