package com.bxm.localnews.news.hotpost.msg.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.hotpost.HotPostSettlementService;
import com.bxm.localnews.news.hotpost.msg.HotPostProcessor;
import com.bxm.localnews.news.model.vo.hotpost.HotPostReadDataDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

/**
 * 热文分享参与消息监听服务
 *
 * @author wzy
 * @version 1.0
 * @date 2021/2/1 3:09 下午
 */
@Slf4j
@Component
@EnableBinding(HotPostProcessor.class)
@AllArgsConstructor
public class HotPostJoinListenerService {

    private HotPostSettlementService hotPostSettlementService;

    /**
     * 监听binding中的消息
     */
    @StreamListener(HotPostProcessor.HOT_POST_INPUT)
    public void handleHotPostJoinEvent(HotPostReadDataDTO hotPostReadDataDTO) {
        log.info("监听到用户阅读有奖热文消息：{}", JSON.toJSONString(hotPostReadDataDTO));
        hotPostSettlementService.handleReadData(hotPostReadDataDTO);
    }
}