package com.bxm.localnews.news.hotpost.msg.sender;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.hotpost.msg.HotPostProcessor;
import com.bxm.localnews.news.model.vo.hotpost.HotPostReadDataDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Component;

/**
 * 热文帖子阅读消息发送服务
 *
 * @author wzy
 * @version 1.0
 * @date 2021/2/1 2:34 下午
 */
@Slf4j
@Component
@EnableBinding(HotPostProcessor.class)
@AllArgsConstructor
public class HotPostJoinMsgSenderService {
    @Qualifier(value = "hotPostOutPut")
    private MessageChannel hotPostOutPut;


    /**
     * 向消息队列中发送用户点击阅读热文消息
     *
     * @param hotPostReadDataDTO 消息对象
     */
    public void send(HotPostReadDataDTO hotPostReadDataDTO) {
        log.info("发送用户点击阅读热文帖子消息：{}", JSON.toJSONString(hotPostReadDataDTO));
        hotPostOutPut.send(MessageBuilder.withPayload(hotPostReadDataDTO).build());
    }

}