package com.bxm.localnews.news.list;

import com.bxm.localnews.news.model.dto.ForumPostPageDTO;
import com.bxm.localnews.news.model.param.FollowUserForumsParam;
import com.bxm.localnews.news.model.param.ForumPostFillContext;
import com.bxm.localnews.news.model.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.model.param.HomePagePostParam;
import com.bxm.localnews.news.model.vo.FollowUserForumPostVo;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 帖子列表相关处理
 *
 * @author liujia
 * @date 1/14/21 4:56 PM
 **/
public interface PostListService {

    /**
     * 填充和处理列表中的帖子的额外信息
     *
     * @param context 填充的相关处理参数
     */
    void fillExtInfo(ForumPostFillContext context);

    /**
     * 个人主页帖子列表
     *
     * @param param
     * @return
     */
    PageWarper<ForumPostVo> getHomePagePostList(HomePagePostParam param);

    /**
     * 获取现金奖励帖子轮播列表
     *
     * @return
     */
    List<ForumPostVo> getRewardPostList();


    /**
     * 根据帖子id列表获取帖子列表
     *
     * @param postIds
     * @return
     */
    List<ForumPostVo> getPostListByIds(String postIds);

    /**
     * 3.10.0 获取用户及关注的用户帖子列表
     *
     * @param param 上行参数
     * @return 帖子集合
     */
    FollowUserForumPostVo getFollowedUserForumList(FollowUserForumsParam param);

    /**
     * 根据用户及类型获取帖子列表
     *
     * @param param
     * @return
     */
    PageWarper<ForumPostVo> listForumPostByUser(ForumPostListUserQueryParam param);
}
