package com.bxm.localnews.news.list.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.domain.ForumPostLikeMapper;
import com.bxm.localnews.news.model.param.ForumPostFillContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;

import javax.annotation.Resource;

import static com.bxm.localnews.news.constant.LogicGroupConstant.POST_LIST_FILTER;

/**
 * @author liujia
 * @date 1/14/21 5:14 PM
 **/
@FilterBean(group = POST_LIST_FILTER)
public class ListLikeFilter implements IFilter<ForumPostFillContext> {

    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;

    @Override
    public void doFilter(ForumPostFillContext context) {
        // 获取用户点赞的所有记录
        if (context.getUserId() != null) {
            if (context.isLoadLikeStatus()) {
                context.setPostLikeIdList(forumPostLikeMapper.listUserPostLike(context.getUserId()));
            }
        }

        context.getData().forEach(forumPostVo -> {
            forumPostVo.setLiked(context.getPostLikeIdList()
                    .stream()
                    .anyMatch(e -> e.equals(forumPostVo.getId())) ? 1 : 0);
        });
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
