package com.bxm.localnews.news.note;

import com.bxm.localnews.news.model.vo.NotePublishVo;
import com.bxm.localnews.news.model.vo.NoteVo;
import com.bxm.newidea.component.vo.Message;

import java.util.Date;
import java.util.List;

/**
 * 小纸条相关服务
 */
public interface NoteService {

    /**
     * 删除小纸条
     *
     * @param noteId
     * @return
     */
    Message delete(Long noteId);

    /**
     * 获取小纸条发布页面参数
     *
     * @param userId
     * @return
     */
    NotePublishVo getNotePublish(Long userId);

    /**
     * 批量获取用户小纸条
     *
     * @param userIdList
     * @param currentUserId
     * @return
     */
    List<NoteVo> batchGetUserNote(List<Long> userIdList, Long currentUserId);

    /**
     * 批量缓存一定时间内更新的用户小纸条
     *
     * @return
     */
    void cacheUserNote(Date startTime);

    /**
     * 删除用户的小纸条缓存
     *
     * @param userId 用户ID
     */
    void removeCache(Long userId);

    /**
     * 获取用户小纸条列表
     *
     * @param userId
     * @return
     */
    List<NoteVo> getUserNoteList(Long userId);

    /**
     * 填充小纸条的公共信息
     *
     * @param noteVo 小纸条信息
     * @param userId 请求用户
     */
    void completeNoteInfo(NoteVo noteVo, Long userId);
}
