package com.bxm.localnews.news.post;

import com.bxm.localnews.news.model.dto.AdminGetPostUrlDTO;
import com.bxm.localnews.news.model.param.AdminForumPostParam;
import com.bxm.localnews.news.model.vo.AdminBaseForumPost;
import com.bxm.localnews.news.model.vo.AdminBaseForumPostExcelVO;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 帖子管理服务
 */
public interface AdminForumPostService {

    /**
     * 查询帖子审核列表
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<AdminBaseForumPost> getApproveList(AdminForumPostParam param);

    /**
     * 查询帖子审核列表
     *
     * @param param 参数
     * @return 分页结果
     */
    List<AdminBaseForumPostExcelVO> getApproveListExcelVO(AdminForumPostParam param);

    /**
     * 获取帖子详情
     *
     * @param id 帖子ID
     * @return 帖子详情
     */
    AdminForumPost selectByPrimaryKey(Long id);

    /**
     * 根据ID列表获取现金奖励帖，用于判断列表批量审核时，其中是否包含现金奖励贴
     * 包含现金奖励贴，则不可直接通过，需要走详情
     *
     * @param ids ID列表
     * @return true表示存在现金奖励帖子
     */
    Boolean hasCashPost(String ids);

    /**
     * 批量删除或恢复帖子
     */
    int deleteOrRecover(String ids, Integer status, Byte deductGold);

    /**
     * 新增帖子时获取新增帖子id，用于提前初始化部分数据
     *
     * @param postType 帖子类型，3：活动帖子，其他：社区帖子
     * @return 帖子ID
     */
    Long getCreateId(Integer postType);

    void importNotes(Long userId, MultipartFile... multipartFiles);

    String getPostUrl(AdminGetPostUrlDTO adminGetPostUrlDTO);
}
