package com.bxm.localnews.news.post;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.model.param.ForumPostUserAtParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumPostVo;

/**
 * @author gonzo
 * @date 2020-10-27 19:59
 **/
public interface ForumPostContentService {

    /**
     * 管理后台创建之后的内容操作
     *
     * @param forumPostVo 帖子信息
     */
    void afterCreate(AdminForumPost forumPostVo);

    /**
     * 预发布帖子发布之后的内容操作
     *
     * @param param 帖子信息
     */
    void afterUp(ForumPostUserAtParam param);

    /**
     * 管理后台编辑之后的内容操作
     *
     * @param forumPostVo 帖子信息
     */
    void pushAtInfo(AdminForumPost forumPostVo);

    /**
     * 替换占位符
     * 将帖子的html内容中需要进行替换的根据场景进行替换
     *
     * @param forumPostVo 帖子
     * @param locationDTO 城市信息
     */
    void replacePlaceHolder(ForumPostVo forumPostVo, LocationDTO locationDTO, BasicParam basicParam, Long userId);


    String replacePlaceHolder(String content, LocationDTO locationDTO, BasicParam basicParam, Long userId);

    /**
     * 替换帖子的标题和内容
     *
     * @param forumPostVo 帖子信息
     * @param locationDTO 地区
     */
    void replacePostTitleOrField(ForumPostVo forumPostVo, LocationDTO locationDTO);
}
