package com.bxm.localnews.news.post;

import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.vo.Message;

import java.util.Date;
import java.util.List;

/**
 * 社区相关服务
 */
public interface ForumPostService {

    /**
     * 删除帖子
     *
     * @param id
     * @return
     */
    Message deleteForumPost(Long id);


    /**
     * 执行帖子内视频转码
     *
     * @param postId      帖子ID
     * @param imageList   帖子内图片、视频列表字符串
     * @param postImgList 帖子内图片、视频列表
     */
    void execTransCode(Long postId, String imageList, List<PostImgVo> postImgList);

    /**
     * 更新帖子中用户头像以及昵称
     *
     * @param userId
     * @param nickname
     * @param headImg
     */
    void doTriggerUpdateInfo(Long userId, String nickname, String headImg);

    /**
     * 更新话题
     *
     * @param postId        帖子ID
     * @param topicIdList   话题ID列表
     * @param secondTopicId 二级话题ID
     */
    void updateTopic(Long postId, List<Long> topicIdList, Long secondTopicId);

    /**
     * 本地圈是否有新内容更新
     *
     * @param lastRequestTime 用户最后一次请求时间
     * @param areaCode        所属地区
     * @return true表示存在新增内容
     */
    Boolean getContentUpdate(Date lastRequestTime, String areaCode);

    /**
     * 完成首次发帖任务以及发帖任务
     *
     * @param forumPostVo
     * @return
     */
    NewsCompleTaskDTO completeTask(ForumPostVo forumPostVo);
}
