package com.bxm.localnews.news.post;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.model.dto.HotForumListShareDTO;
import com.bxm.localnews.news.model.param.ForumPostListQueryParam;
import com.bxm.localnews.news.model.param.HotForumListShareParam;
import com.bxm.localnews.news.model.param.HotForumsParam;
import com.bxm.localnews.news.model.vo.HotForumPostVo;
import com.bxm.localnews.news.model.vo.TopicHotForumGuideInfo;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * @author liujia
 * @date 1/14/21 6:27 PM
 **/
public interface HotPostService {
    /**
     * 3.9.0需求
     * <p>
     * 获取热帖列表（阅读PV/10+评论数*10+点赞数*5）
     *
     * @param param
     * @return
     */
    PageWarper<HotForumPostVo> hotForumPost(HotForumsParam param);

    /**
     * 3.9.0
     * <p>
     * 从库里取热门贴原始数据并入缓存
     *
     * @param areaCode
     * @return
     */
    List<HotForumPostVo> loadFromDb(String areaCode);

    /**
     * 3.9.0 需求
     * <p>
     * 热门贴分享内容包装
     *
     * @param param 分享上行参数
     * @return 分享内容实体
     */
    HotForumListShareDTO hotForumsShareBaseInfo(HotForumListShareParam param);

    /**
     * 获取指定地区的人帖子
     *
     * @param areaCode 地区编码
     * @return 热门贴信息
     */
    List<HotForumPostVo> getHotForumList(String areaCode);

    /**
     * 加载话题下的热门帖子，保存五分钟
     *
     * @param param      查询参数
     * @param basicParam 请求基础参数
     * @return 话题下的区域下的带图的热门帖子
     */
    TopicHotForumGuideInfo loadTopicHotPost(ForumPostListQueryParam param, BasicParam basicParam);
}
