package com.bxm.localnews.news.post;

/**
 * @author gonzo
 * @date 2020-10-28 21:27
 **/
public interface PostCountService {
    /**
     * 获取初始基数
     * 初始基数：本地用户数 * 随机比例
     *
     * @param areaCode    城市编码 可以为空
     * @param isRecommend 是否推荐帖子
     * @return 初始基数
     */
    long getInitialBasicNum(String areaCode, boolean isRecommend);

    /**
     * 获取初始基数
     * 初始基数：本地用户数 * 随机比例
     *
     * @param areaCode    城市编码 可以为空
     * @param isRecommend 是否推荐帖子
     * @return 初始基数
     */
    long getInitialBasicNum(String areaCode, Byte isRecommend);

    /**
     * 获取帖子的应有阅读量
     * 初始基数 * (1 + ln2 真实阅读量 / 10) + 真实阅读量
     *
     * @param realClickCount 真实阅读量
     * @param areaCode       城市编码 可以为空
     * @param isRecommend    是否推荐帖子
     * @return 帖子的应有阅读量
     */
    long getFinalClickCount(long realClickCount, String areaCode, boolean isRecommend);

    /**
     * 获取帖子的应有阅读量
     * 初始基数 * (1 + ln2 真实阅读量 / 10) + 真实阅读量
     *
     * @param realClickCount  真实阅读量
     * @param initialBasicNum 初始基数
     * @return 帖子的应有阅读量
     */
    long getFinalClickCount(long realClickCount, long initialBasicNum);
}
