package com.bxm.localnews.news.post;

import com.bxm.localnews.news.create.process.PostProcess;
import com.bxm.localnews.news.model.enums.SpecialForumEnum;
import com.bxm.localnews.news.model.param.PostProcessContext;
import com.bxm.localnews.news.model.param.PostSpecialForumParam;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import static com.alibaba.fastjson.JSON.toJSONString;

/**
 * @author gonzo
 * @date 2020-11-25 15:52
 **/
@Slf4j
@Service
public class SpecialForumPostPoster {

    @Autowired
    private List<PostProcess> postProcessList;

    private static final Map<SpecialForumEnum, PostProcess> POST_PROCESS_MAP = Maps.newHashMap();


    @PostConstruct
    public void init() {
        postProcessList.forEach(p -> {
            POST_PROCESS_MAP.put(p.support(), p);
        });
    }

    /**
     * 发送特殊帖子
     *
     * @param param 基础参数 用户参数 帖子类型等等
     * @return 发帖结果
     */
    public Message postSpecialForum(PostSpecialForumParam param) {
        PostProcess postProcess;
        if ((postProcess = findProcess(param.getType())) == null) {
            log.warn("获取帖子处理类失败，类型: {} 没有可用的帖子处理类, param: {}", param.getType(), toJSONString(param));
            return Message.build(false, "发帖失败");
        }

        return postProcess.post(PostProcessContext.builder()
                .param(param)
                .build());
    }

    private PostProcess findProcess(Integer type) {
        if (Objects.isNull(type)) {
            return null;
        }

        return SpecialForumEnum.getByType(type).map(POST_PROCESS_MAP::get).orElse(null);
    }
}
