package com.bxm.localnews.news.post.impl;


import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.AdminCommonTagMapper;
import com.bxm.localnews.news.model.vo.AdminCommonTag;
import com.bxm.localnews.news.post.AdminCommonTagService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminCommonTagServiceImpl implements AdminCommonTagService {

    private final AdminCommonTagMapper adminCommonTagMapper;

    private Logger logger = LoggerFactory.getLogger(AdminCommonTagServiceImpl.class);

    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public AdminCommonTagServiceImpl(AdminCommonTagMapper adminCommonTagMapper,
                                     RedisHashMapAdapter redisHashMapAdapter) {
        this.adminCommonTagMapper = adminCommonTagMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public long saveAndGetTag(String tagName) {
        logger.info("获取tagName:{}", tagName);
        long hashCode = tagName.hashCode();

        long collectionIndex = hashCode % 10;
        KeyGenerator tagKey = RedisConfig.SPIDER_TAG_INDEX.copy().appendKey(collectionIndex);

        Long id = redisHashMapAdapter.get(tagKey, tagName, Long.class);
        if (null == id) {
            //id使用数据库自增 需用作坐标计算 不可以无序且过大
            AdminCommonTag tag = adminCommonTagMapper.findByName(tagName);
            if (tag == null) {
                tag = new AdminCommonTag();
                tag.setName(tagName);
                adminCommonTagMapper.insert(tag);
            }
            logger.info("tag.getId()={}", tag.getId());
            redisHashMapAdapter.put(tagKey, tagName, tag.getId());
            return tag.getId();
        }

        return id;
    }
}
