package com.bxm.localnews.news.post.impl;

import com.bxm.localnews.news.domain.AdminEditorMessageMapper;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.model.param.AdminEditorMessageParam;
import com.bxm.localnews.news.model.vo.AdminBasicEditorMessage;
import com.bxm.localnews.news.model.vo.AdminEditorMessage;
import com.bxm.localnews.news.post.AdminEditorMessageService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author liujia
 */
@Service
public class AdminEditorMessageServiceImpl extends BaseService implements AdminEditorMessageService {

    private final AdminEditorMessageMapper adminEditorMessageMapper;

    private final AdminForumPostMapper adminForumPostMapper;

    @Autowired
    public AdminEditorMessageServiceImpl(AdminEditorMessageMapper adminEditorMessageMapper,
                                         AdminForumPostMapper adminForumPostMapper) {
        this.adminEditorMessageMapper = adminEditorMessageMapper;
        this.adminForumPostMapper = adminForumPostMapper;
    }

    @Override
    public int doSaveOrUpdateEditorMessage(AdminEditorMessageParam param) {
        if (Objects.isNull(param.getId()) || param.getId() == 0) {
            //新增编辑寄语
            AdminEditorMessage adminEditorMessage = convert(param);
            return adminEditorMessageMapper.insertSelective(adminEditorMessage);
        } else {
            //修改编辑寄语
            AdminEditorMessage adminEditorMessage = new AdminEditorMessage();
            BeanUtils.copyProperties(param, adminEditorMessage);
            adminEditorMessage.setModifyTime(new Date());
            int result = adminEditorMessageMapper.updateByPrimaryKeySelective(adminEditorMessage);
            int newsNum = adminEditorMessageMapper.updateEditMessageById(param);
            int postNum = adminForumPostMapper.updateEditMessageById(param);
            logger.info("更新帖子表寄语数量[{}],更新新闻表寄语数量[{}]", postNum, newsNum);
            return result;
        }
    }

    public AdminEditorMessage convert(AdminEditorMessageParam param) {
        AdminEditorMessage adminEditorMessage = new AdminEditorMessage();
        BeanUtils.copyProperties(param, adminEditorMessage);
        Date current = new Date();
        adminEditorMessage.setCreateTime(current);
        adminEditorMessage.setModifyTime(current);
        adminEditorMessage.setCreateId(param.getUserId());
        return adminEditorMessage;
    }

    @Override
    public AdminEditorMessage getEditorMessage(Long id) {
        return adminEditorMessageMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<AdminBasicEditorMessage> listAll() {
        return adminEditorMessageMapper.getList(null);
    }

    @Override
    public PageWarper<AdminBasicEditorMessage> listPage(PageParam pageParam) {
        return new PageWarper<>(adminEditorMessageMapper.getList(pageParam));
    }

    @Override
    public int deleteById(Long id) {
        int count = adminEditorMessageMapper.deleteByPrimaryKey(id);
        int newsNum = adminEditorMessageMapper.deleteEditMessageById(id);
        int postNum = adminForumPostMapper.deleteEditMessageById(id);

        logger.info("更新帖子表寄语数量[{}],更新新闻表寄语数量[{}]", postNum, newsNum);

        return count;
    }
}
