package com.bxm.localnews.news.post.impl;

import com.bxm.localnews.facade.NewsSyncFeignService;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.domain.AdminForumPostMapper;
import com.bxm.localnews.news.enums.NewsTagTypeEnum;
import com.bxm.localnews.news.model.param.Keyword;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.PendingContent;
import com.bxm.localnews.news.model.vo.PostTag;
import com.bxm.localnews.news.post.AdminCommonTagService;
import com.bxm.localnews.news.post.PostTagService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.AllArgsConstructor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author liujia
 * @date 1/18/21 3:56 PM
 **/
@Service
@AllArgsConstructor
public class PostTagServiceImpl implements PostTagService {

    private final AdminForumPostMapper adminForumPostMapper;

    private final BizConfigProperties bizConfigProperties;

    private final NewsSyncFeignService newsSyncService;

    private final SequenceCreater sequenceCreater;

    private final AdminCommonTagService adminCommonTagService;

    /**
     * 重置帖子的标签
     *
     * @param adminForumPost 帖子
     */
    @Override
    public void resetForumPostTag(AdminForumPost adminForumPost) {
        this.adminForumPostMapper.deletePostTag(adminForumPost.getId());
        this.savePostTag(adminForumPost);
    }

    /**
     * 获取分词标签并保存
     *
     * @param adminForumPost 帖子
     */
    @Override
    public void savePostTag(AdminForumPost adminForumPost) {
        if (!bizConfigProperties.getEnablePostTagParse()) {
            return;
        }
        PendingContent pendingContent = new PendingContent();
        pendingContent.setTitle(adminForumPost.getTitle());
        pendingContent.setContent(adminForumPost.getContent());
        ResponseEntity<List<Keyword>> responseEntity = newsSyncService.analysisContent(pendingContent);
        if (responseEntity.getStatusCode().isError()) {
            return;
        }

        List<Keyword> tagList = responseEntity.getBody();
        if (CollectionUtils.isNotEmpty(tagList)) {
            for (Keyword keyword : tagList) {
                PostTag postTag = new PostTag();
                postTag.setId(sequenceCreater.nextLongId());
                postTag.setName(keyword.getName());
                postTag.setTagType(NewsTagTypeEnum.TITLE_TAG.getCode());
                postTag.setWeight(keyword.getTfidfvalue());
                postTag.setPostId(adminForumPost.getId());
                postTag.setTagId(adminCommonTagService.saveAndGetTag(keyword.getName()));
                adminForumPostMapper.savePostTag(postTag);
            }
        }
    }
}
