package com.bxm.localnews.news.recommend;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.model.param.ForumPostListQueryParam;
import com.bxm.localnews.news.model.vo.AdminForumPost;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 帖子推荐相关逻辑
 *
 * @author liujia
 * @date 1/15/21 10:22 AM
 **/
public interface RecommendPostService {

    List<Long> getRecommendPostIds(ForumPostListQueryParam param, BasicParam basicParam);

    /**
     * 根据板块或者话题推荐帖子
     *
     * @param param
     * @param basicParam
     * @return
     */
    PageWarper<ForumPostVo> listForumPost(ForumPostListQueryParam param, BasicParam basicParam);

    /**
     * 更新推荐池内容
     * 当目前状态是<正常显示>时，更新在推荐库中的内容
     * 否则删除在推荐库中的内容
     *
     * @param adminForumPost 帖子
     */
    void updateRecommendWhenChanged(AdminForumPost adminForumPost);

    /**
     * 取消帖子的混合推荐
     *
     * @param postId 帖子ID
     */
    void cancelRecommend(Long postId);
}
