package com.bxm.localnews.news.recommend;

import com.bxm.localnews.news.model.vo.TopicForumInfo;

import java.util.List;

/**
 * 3.10.0 版本需求
 *
 * @author pf.w
 * @date 2020/12/14 14:25
 **/
public interface TopicForumService {

    /**
     * 3.10.0   加载某个话题下最近的 limitNum 个有图的帖子
     * <p>
     * save to redis
     *
     * @param topicId 话题ID
     * @return 帖子数据实体
     */
    List<TopicForumInfo> loadForumInfosByTopicId(Long topicId, String areaCode);

    /**
     * 3.10.0   获取某个话题下最近的 limitNum 个有图的帖子基础信息
     * <p>
     * get from redis or load replace
     *
     * @param topicId 话题ID
     * @return 帖子数据实体
     */
    List<TopicForumInfo> getForumInfosByTopicId(Long topicId, String areaCode);

    /**
     * 组装推荐话题到信息流
     *
     * @param list 信息流
     * @param type 1：头条信息流推荐  2：本地圈信息信息流推荐
     * @return 带话题信息流
     */
    Object recommendTopic(Object list, Integer type, Long userId, String areaCode);
}
