package com.bxm.localnews.news.statistics;

import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;

import java.util.List;

/**
 * 社区相关静态数据服务
 */
public interface ForumPostStatisticService {


    /**
     * 对帖子的消费次数进行消费，对帖子的次数进行增加
     *
     * @param ids
     * @param userId
     */
    void doConsumeRecommendedCount(List<Long> ids, Long userId);


    /**
     * 帖子点赞概览,评论概览信息同步
     */
    void doSyncPostStaticInfo();

    /**
     * 统计客户端最近半小时发帖情况
     *
     * @return
     */
    List<CalculatePostDTO> calculatePostCount();

    /**
     * 计算参与人数
     */
    void calcParticipantsNum();


    /**
     * 帖子增加马甲号评论
     *
     * @param forumPostVo
     * @return
     */
    void addPostReply(ForumPostVo forumPostVo);


    /**
     * 添加面包块消息数量
     *
     * @param deliveryType 发布区域类型 0全国 1地方
     * @param areaCode     区域编码
     * @param postType     帖子类型(1:普通帖子 2:小纸条)
     */
    void addCrumbsTotal(Integer deliveryType, String areaCode, Byte postType);
}
