package com.bxm.localnews.news.task;

import com.bxm.localnews.news.domain.PostHotScoreMapper;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * 定期归档计算历史帖子的热度值，衰减热度值
 * 计算发布30天之前的数据，处理当前日期往前推31天的数据
 * 计算处理30天之前发布的内容，并且近期有更新的数据
 *
 * @author liujia
 * @date 2/1/21 4:35 PM
 **/
@Component
@Slf4j
public class CalcHistoryPostHotScoreTask extends AbstractCronTask {

    @Resource
    private PostHotScoreMapper postHotScoreMapper;

    @Override
    protected ReturnT<String> service(Object o) {
        //计算发布30天之前的数据，处理当前日期往前推31天的数据
        Date startTime = DateUtils.addField(new Date(), Calendar.DAY_OF_YEAR, -31);
        Date lastTime = DateUtils.addField(new Date(), Calendar.DAY_OF_YEAR, -30);

        int recordNum = postHotScoreMapper.updateHistoryScoreInterval(startTime, lastTime);

        log.info("符合衰减周期的帖子数量：{}", recordNum);

        // 30天之前发布的帖子，并且2天之内有变更，则重新计算
        Date startModifyTime = DateUtils.addField(new Date(), Calendar.DAY_OF_YEAR, -2);
        postHotScoreMapper.updateHistoryByModifyTime(lastTime, startModifyTime);

        log.info("历史帖子，近期有数据变更的帖子数量：{}", recordNum);

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return CalcHistoryPostHotScoreTask.class.getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0 3 * * ? ";
    }
}
