package com.bxm.localnews.news.task;

import com.bxm.localnews.news.domain.PostHotScoreMapper;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * 实时计算帖子的热度值
 * 计算发布时间在30天之内的数据，每次选择近30分钟有变动的数据
 *
 * @author liujia
 * @date 2/1/21 4:35 PM
 **/
@Component
@Slf4j
public class CalcRuntimePostHotScoreTask extends AbstractCronTask {

    @Resource
    private PostHotScoreMapper postHotScoreMapper;

    @Override
    protected ReturnT<String> service(Object o) {
        Date startPublishTime = DateUtils.addField(new Date(), Calendar.DAY_OF_YEAR, -30);
        Date lastModifyTime = DateUtils.addField(new Date(), Calendar.MINUTE, -30);

        int recordNum = postHotScoreMapper.updateRuntimeScore(startPublishTime, lastModifyTime);

        log.info("重新计算帖子热度值，更新条数：{}", recordNum);

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return CalcRuntimePostHotScoreTask.class.getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0/10 * * * ? ";
    }
}
