package com.bxm.localnews.news.task;

import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.statistics.ForumPostStatisticService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * 创建即发布的周期定时任务
 * 统计5分钟的审核、发帖、等数据。发送到钉钉上
 */
@Component
@Slf4j
public class CalculatePostTask extends AbstractCronTask<String> {

    @Resource
    private ForumPostStatisticService forumPostStatisticService;

    @Resource
    private MessageSender messageSender;

    @Override
    protected ReturnT<String> service(String param) {
        List<CalculatePostDTO> calculatePostList = forumPostStatisticService.calculatePostCount();
        if (CollectionUtils.isNotEmpty(calculatePostList)) {
            StringBuilder content = new StringBuilder();
            content.append("------").append(DateFormatUtils.format(new Date(), "MM月dd日HH时mm分")).append("------\n");
            calculatePostList.forEach(e -> {
                content.append("地区：[").append(e.getAreaName()).append("]\n");
                content.append("最近5分钟新增待审核帖子：[").append(e.getPendingReviewCount()).append("]\n");
                content.append("最近5分钟手机端发帖数量：[").append(e.getNewPostCount()).append("]\n");
                content.append("最近5分钟手机端发帖人数：[").append(e.getUserCount()).append("]\n");
            });

            messageSender.sendDingtalk(DingtalkMessage.builder()
                    .content(content.toString())
                    .scene("news")
                    .build());
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "calculatePostTask";
    }

    @Override
    public String cron() {
        return "0 0/5 * * * ? ";
    }

    @Override
    public String description() {
        return "客户端发帖消息通知";
    }

}
