package com.bxm.localnews.news.task;

import com.bxm.localnews.news.action.PostLikeService;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 3.11.0 临时需求(陈媛媛)：
 * 帖子发布后30秒提前展示点赞信息
 *
 * @author liujia
 * @date 2/1/21 3:46 PM
 **/
@Component
@Slf4j
public class FirstPostLikeCallback extends AbstractTaskCallback<Long> {
    @Resource
    private PostLikeService postLikeService;

    @Override
    protected ReturnT<String> service(Long postId) {
        if (log.isDebugEnabled()) {
            log.debug("前置刷新点赞记录：{}", postId);
        }

        postLikeService.doRefreshLikeInfo(postId);
        return ReturnT.SUCCESS;
    }
}
