/*
 * Copyright 2019 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.model.param.ForumPostUserAtParam;
import com.bxm.localnews.news.post.ForumPostContentService;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 定时发布帖子的@用户定时任务
 */
@Component
@Slf4j
public class ForumPostUserAtTask extends AbstractTaskCallback<ForumPostUserAtParam> {

    private ForumPostContentService forumPostContentService;

    @Override
    protected ReturnT<String> service(ForumPostUserAtParam param) {
        log.info("定时发布帖子的@用户定时任务, param: {}", JSON.toJSONString(param));

        try {
            getForumPostContentService().afterUp(param);
        } catch (Exception e) {
            log.error("定时发布帖子的@用户定时任务出现错误, param: {} ", JSON.toJSONString(param), e);
            return ReturnT.FAIL;
        }

        return ReturnT.SUCCESS;
    }

    private ForumPostContentService getForumPostContentService() {
        if (Objects.isNull(forumPostContentService)) {
            forumPostContentService = SpringContextHolder.getBean(ForumPostContentService.class);
        }
        return forumPostContentService;
    }

    public static String generateTaskName(Long postId) {
        return "定时发布帖子的@用户定时任务_" + postId;
    }

}
