package com.bxm.localnews.news.task;

import com.bxm.localnews.news.hotpost.HotPostSettlementService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 定时处理分享帖子阅读数据
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/19 3:42 下午
 */
//@Component
@Slf4j
@AllArgsConstructor
public class HotPostShareConsumerTask extends AbstractCronTask<String> {

    public final HotPostSettlementService hotPostSettlementService;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("==================热文帖子有效阅读计算定时任务开启===================");
        try {
//            hotPostSettlementService.handleReadData();
        } catch (Exception e) {
            log.error("热文帖子有效阅读计算定时任务处理失败", e);
        }
        log.info("==================热文帖子有效阅读计算定时任务结束===================");
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "每分钟计算用户的热文帖子有效阅读数据_LOCAL_NEWS_NEWS";
    }

    @Override
    public String cron() {
        return "0 */1 * * * ?";
    }
}