package com.bxm.localnews.news.task;

import com.bxm.localnews.news.hotpost.HotPostSettlementService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/1/19 4:48 下午
 */
@Component
@Slf4j
@AllArgsConstructor
public class HotPostShareSettlementTask extends AbstractCronTask<String> {
    private final HotPostSettlementService hotPostSettlementService;

    @Override
    protected ReturnT<String> service(String s) {
        log.info("==================热文帖子结算定时任务开启===================");
        try {
            hotPostSettlementService.settlementHotPostCash();
        } catch (Exception e) {
            log.error("热文帖子结算定时任务处理失败", e);
        }
        log.info("==================热文帖子结算定时任务结束===================");
        return ReturnT.SUCCESS;
    }


    @Override
    public String taskName() {
        return "热文分享结算任务，每天凌晨两点执行一次";
    }

    @Override
    public String cron() {
        return "0 0 2 * * ?";
    }
}