package com.bxm.localnews.news.task;

import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.recommend.TopicForumService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Set;

/**
 * 每20分钟同步一次 帖子信息流中插入话题时的帖子图片信息
 *
 * @author pf.w
 * @date 2020/12/18 14:54
 **/
@Component
@Slf4j
public class RecommendTopicForForumInfoTask extends AbstractCronTask<String> {

    @Resource
    private TopicForumService topicForumService;

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    protected ReturnT<String> service(String s) {
        Set<String> topicIdStr = redisHashMapAdapter.keys(buildKey());
        topicIdStr.forEach(idStr -> {
            String[] idStrInfos = idStr.split("#");
            if (idStrInfos.length >= 2) {
                topicForumService.loadForumInfosByTopicId(Long.parseLong(idStrInfos[0]), idStrInfos[1]);
            } else {
                log.error("帖子信息流中插入话题时的帖子图片信息, 缓存帖子信息不合法：{}", idStr);
            }
        });

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncRecommendTopicForumTask";
    }

    @Override
    public String cron() {
        return "0 /20 * * * ? ";
    }

    @Override
    public String description() {
        return "同步插入推荐话题帖子图片内容";
    }

    /**
     * 缓存key
     *
     * @return key
     */
    private KeyGenerator buildKey() {
        return RedisConfig.FORUM_LIMITNUM_TOPIC_NEW.copy();
    }
}
