package com.bxm.localnews.news.task;

import com.bxm.localnews.news.topic.ForumTopicService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 话题缓存中包含了
 *
 * @author liujia
 * @date 1/22/21 9:41 AM
 **/
@Component
public class RefreshTopicCacheTask extends AbstractCronTask {

    @Resource
    private ForumTopicService forumTopicService;

    @Override
    protected ReturnT<String> service(Object param) {
        forumTopicService.reloadCache();
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String cron() {
        return "0 0/20 * * * ? ";
    }

    @Override
    public String description() {
        return "定期刷新话题的缓存数据";
    }
}
