package com.bxm.localnews.news.task;

import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.post.HotPostService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 热门贴榜单
 *
 * @author pf.w
 * @date 2020/11/24 16:52
 **/
@Component
@Slf4j
public class SyncHotForumTask extends AbstractCronTask<String> {

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private HotPostService hotPostService;

    @Override
    protected ReturnT<String> service(String s) {
        KeyGenerator hotForumKey = RedisConfig.FORUM_HOT_LIST.copy();

        redisHashMapAdapter.keys(hotForumKey).forEach(areaCode -> {
            hotPostService.loadFromDb(areaCode);
        });

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncHotForumTask";
    }

    @Override
    public String cron() {
        return "0 0 0/2 * * ?";
    }

    @Override
    public String description() {
        return "同步热门贴";
    }
}
