package com.bxm.localnews.news.topic;

import com.bxm.localnews.news.model.param.AdminTopicParam;
import com.bxm.localnews.news.model.vo.AdminTopic;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * 话题的相关运营管理后台逻辑
 *
 * @author liujia
 */
public interface AdminTopicService {

    /**
     * 查询话题
     *
     * @param param 参数
     * @return 分页结果
     */
    PageWarper<AdminTopic> getList(AdminTopicParam param);

    /**
     * 获取话题详情
     *
     * @param id
     * @return
     */
    AdminTopic selectByPrimaryKey(Long id);

    /**
     * 话题上下架删除
     *
     * @return 更新信息
     */
    int updateStatus(Long id, Byte status);

    /**
     * 新增或编辑话题
     *
     * @param adminTopic
     * @return
     */
    int saveOrUpdate(AdminTopic adminTopic);

    /**
     * 修改话题权重
     *
     * @param id
     * @param order
     * @return
     */
    int updateOrder(Long id, Integer order);

    /**
     * 获取简单话题列表
     *
     * @param key 关键字
     * @return
     */
    List<AdminTopic> getSimpleList(String key);

    /**
     * 获取话题下的帖子数
     *
     * @param id
     * @return
     */
    Integer getPostNumByTopicId(Long id);

    /**
     * 批量更新帖子为某个话题
     *
     * @param topicId
     * @param postIdList
     */
    void batchUpdatePostTopic(Long topicId, List<Long> postIdList);

}
