package com.bxm.localnews.news.topic;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.model.vo.TopicVo;

/**
 * 话题引到弹窗的相关逻辑
 *
 * @author liujia
 * @date 1/21/21 4:26 PM
 **/
public interface TopicPopService {

    /**
     * 3.10.0 [wpf]需求
     * 逻辑 ：
     * 首页发帖加号“+” 点击进来要弹 所以使用一个type字段，该字段由加号路由地址带入（因为这个地方进来的不一定是话题，比如“随便说说”）
     * 但是但是某些话题其他地方不管从哪里进来都要弹（比如：本地爆料。。这就比较尴尬，不讲一点武德）
     *
     * @param topicInfo 话题信息
     * @param type      3.10.0  发帖按钮过来的type值  910001：随便聊聊    910002：本地爆料  为详情弹窗用 可为空
     * @param userId    请求用户
     * @param location  用户地址信息
     */
    void loadTopicPop(TopicVo topicInfo, Integer type, Long userId, LocationDTO location);
}
