package com.bxm.localnews.news.topic.context;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.model.vo.TopicVo;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * 话题详情填充上下文
 *
 * @author liujia
 * @date 1/21/21 7:01 PM
 **/
@Data
@Builder
public class TopicContext {

    @Tolerate
    public TopicContext() {
    }

    /**
     * 当前处理的话题详情
     */
    private TopicVo topic;

    /**
     * 当前请求对应的地区信息
     */
    @Builder.Default
    private LocationDTO location = new LocationDTO();

    /**
     * 当前请求的用户ID，可能为空
     */
    private Long userId;

    /**
     * 发帖按钮过来的type值  910001：随便聊聊    910002：本地爆料  为详情弹窗用 可为空
     */
    private Integer popType;
}
