package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.TopicPopService;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import static com.bxm.localnews.news.constant.LogicGroupConstant.TOPIC_FILL_FILTER;

/**
 * 填充话题的弹窗引导
 *
 * @author liujia
 * @date 1/21/21 7:52 PM
 **/
@AllArgsConstructor
@FilterBean(group = TOPIC_FILL_FILTER)
@Slf4j
public class TopicGuidePopFilter implements IFilter<TopicContext> {

    private TopicPopService topicPopService;

    @Override
    public void doFilter(TopicContext context) {
        if (context.getPopType() != null) {
            TopicVo topicVo = context.getTopic();
            topicPopService.loadTopicPop(topicVo, context.getPopType(), context.getUserId(), context.getLocation());
        }
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
