package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import static com.bxm.localnews.news.constant.LogicGroupConstant.TOPIC_FILL_FILTER;

/**
 * 填充话题的参与人信息
 *
 * @author liujia
 * @date 1/21/21 7:02 PM
 **/
@FilterBean(group = TOPIC_FILL_FILTER)
@AllArgsConstructor
public class TopicJoinerFilter implements IFilter<TopicContext> {

    private ForumTopicMapper forumTopicMapper;

    private NewsReplyMapper newsReplyMapper;

    private static final int JOIN_USER_NUM = 5;

    @Override
    public void doFilter(TopicContext context) {
        TopicVo topicVo = context.getTopic();

        //先获取话题下发帖人头像
        List<String> postHeadImgList = forumTopicMapper.getPostHeadImgList(topicVo.getId());
        //获取不到发帖人头像，则说明该话题无人参与，直接跳过
        if (CollectionUtils.isEmpty(postHeadImgList)) {
            return;
        }

        Set<String> joinHeadImgSet = new HashSet<>(postHeadImgList);

        if (joinHeadImgSet.size() < JOIN_USER_NUM) {
            //数量不够，则再获取话题下评论人头像，由于评论分表，所以需要挨个查
            List<Long> postIdList = forumTopicMapper.getPostIdListByTopicId(topicVo.getId());
            boolean isNotEnough = false;

            if (CollectionUtils.isNotEmpty(postIdList)) {
                for (Long postId : postIdList) {
                    List<String> replyHeadImgList = newsReplyMapper.getReplyHeadImgList(postId);
                    if (CollectionUtils.isNotEmpty(replyHeadImgList)) {
                        joinHeadImgSet.addAll(replyHeadImgList);

                        if (joinHeadImgSet.size() >= 5) {
                            break;
                        }
                    }
                }

                if (joinHeadImgSet.size() < JOIN_USER_NUM) {
                    isNotEnough = true;
                }
            }

            if (isNotEnough) {
                //数量仍然不够，则再取话题下点赞人
                List<String> likeHeadImgList = forumTopicMapper.getLikeHeadImgList(topicVo.getId());
                if (CollectionUtils.isNotEmpty(likeHeadImgList)) {
                    joinHeadImgSet.addAll(likeHeadImgList);
                }
            }
        }

        topicVo.setJoinHeadImgList(joinHeadImgSet.stream().limit(JOIN_USER_NUM).collect(Collectors.toList()));
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
