package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.sync.core.CacheHolder;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.concurrent.TimeUnit;

import static com.bxm.localnews.news.constant.LogicGroupConstant.TOPIC_FILL_FILTER;
import static com.bxm.localnews.news.constant.MemoryCacheKey.TOPIC_PARTICIPANT_NUM;

/**
 * 获取话题对应的地区的参与人数信息，同一个话题投放在不同的定期会有不同的参与人数
 * 这个数值不怎么重要，直接放到内存缓存中即可
 *
 * @author liujia
 * @date 1/21/21 7:52 PM
 **/
@AllArgsConstructor
@FilterBean(group = TOPIC_FILL_FILTER)
@Slf4j
public class TopicParticipantNumFilter implements IFilter<TopicContext> {

    private CacheHolder cacheHolder;

    private ForumTopicMapper forumTopicMapper;

    @Override
    public void doFilter(TopicContext context) {
        TopicVo topicVo = context.getTopic();

        if (null != context.getLocation() && StringUtils.isNotBlank(context.getLocation().getCode())) {
            topicVo.setParticipantsNum(loadParticipantNum(topicVo.getId(),
                    context.getLocation().getCode(),
                    topicVo.getParticipantsNum()));
        }
    }

    private Long loadParticipantNum(Long topicId, String areaCode, Long defaultNum) {
        String subKey = topicId + areaCode;

        Long num = cacheHolder.get(TOPIC_PARTICIPANT_NUM, subKey);

        if (null == num) {
            num = forumTopicMapper.getParticipantsNum(topicId, areaCode);
            if (num == null || num <= 0) {
                num = defaultNum;
            }

            Long finalNum = num;
            cacheHolder.set(TOPIC_PARTICIPANT_NUM, (key) -> finalNum,
                    1000,
                    TimeUnit.MINUTES, 1);
        }

        return num;
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
