package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.localnews.news.util.PlaceHolderUtil;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import static com.bxm.localnews.news.constant.LogicGroupConstant.TOPIC_FILL_FILTER;

/**
 * 过滤和处理占位符信息
 * 填充话题的推荐语信息
 *
 * @author liujia
 * @date 1/21/21 7:10 PM
 **/
@AllArgsConstructor
@FilterBean(group = TOPIC_FILL_FILTER)
@Slf4j
public class TopicPlaceHolderFilter implements IFilter<TopicContext> {

    private ForumProperties forumProperties;

    @Override
    public void doFilter(TopicContext context) {
        TopicVo topicVo = context.getTopic();
        LocationDTO location = context.getLocation();
        if (location == null) {
            location = new LocationDTO();
        }
        String recommendContent = topicVo.getRecommendContent();

        if (StringUtils.isBlank(recommendContent)) {
            recommendContent = forumProperties.getDefaultRecommendContent();
        }
        topicVo.setRecommendContent(replaceVariable(recommendContent, topicVo, location));

        //3.10.0 版本添加 引导弹窗文案
        topicVo.setGuidePopText(replaceVariable(topicVo.getGuidePopText(), topicVo, location));
    }

    private String replaceVariable(String content, TopicVo topicVo, LocationDTO location) {
        content = PlaceHolderUtil.replace(content, "areaname", location.getName(), "全国");
        content = PlaceHolderUtil.replace(content, "areaName", location.getName(), "全国");
        return PlaceHolderUtil.replace(content, "topicname", topicVo.getTitle(), "话题");
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
