package com.bxm.localnews.news.topic.filter;

import com.bxm.localnews.news.constant.OrderConstant;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.model.vo.TopicVo;
import com.bxm.localnews.news.topic.context.TopicContext;
import com.bxm.newidea.component.annotations.FilterBean;
import com.bxm.newidea.component.filter.IFilter;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;
import java.util.Objects;

import static com.bxm.localnews.news.constant.LogicGroupConstant.TOPIC_FILL_FILTER;

/**
 * 运行时信息计算，根据参数动态获取
 *
 * @author liujia
 * @date 1/21/21 8:00 PM
 **/
@AllArgsConstructor
@FilterBean(group = TOPIC_FILL_FILTER)
@Slf4j
public class TopicRuntimeFilter implements IFilter<TopicContext> {

    private IUrlFactory iUrlFactory;

    @Override
    public void doFilter(TopicContext context) {
        TopicVo topicVo = context.getTopic();

        //3.10.0 重新计算热帖是否失效
        if (Objects.nonNull(topicVo.getHasReward()) && topicVo.getHasReward() == 1) {
            Date now = new Date();
            if (Objects.nonNull(topicVo.getRewardEndTime()) && Objects.nonNull(topicVo.getRewardStartTime())) {
                topicVo.setHasReward((DateUtils.before(now, topicVo.getRewardEndTime())
                        && DateUtils.after(now, topicVo.getRewardStartTime())) ? 1 : 0);
            }
        }

        topicVo.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, topicVo.getId(), context.getUserId()));
        topicVo.setShareUrl(iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.TOPIC, topicVo.getId(), context.getUserId()));
    }

    @Override
    public int getOrder() {
        return OrderConstant.getOrder(this.getClass());
    }
}
